<?php
/**
 * Plugin Name: App.WPRO
 * Description: Siparis durumu degistikce mesaj gonderir ve manuel mesaj gonderimi saglar.
 * Version: 1.1.4
 * Author: Selahattin ÇEKİÇ
 */

if (!defined('ABSPATH')) exit;

add_action('admin_menu', 'osm_add_admin_menu');
function osm_add_admin_menu() {
    add_menu_page('App.WPRO', 'App.WPRO', 'manage_options', 'osm-settings', 'osm_settings_page');
    add_submenu_page('osm-settings', 'Status Messages', 'Status Messages', 'manage_options', 'osm-status-messages', 'osm_status_messages_page');
    add_submenu_page('osm-settings', 'Manual Messaging', 'Manual Messaging', 'manage_options', 'osm-manual-messaging', 'osm_manual_messaging_page');
}

function osm_settings_page() {
    if (isset($_POST['osm_save_settings']) && check_admin_referer('osm_settings_form')) {
        update_option('osm_appkey', sanitize_text_field($_POST['osm_appkey']));
        update_option('osm_authkey', sanitize_text_field($_POST['osm_authkey']));
        echo '<div class="updated"><p>Ayarlar kaydedildi.</p></div>';
    }
    $appkey = get_option('osm_appkey', '');
    $authkey = get_option('osm_authkey', '');
    echo '<div class="wrap"><h1>App.WPRO Ayarları</h1><form method="post">';
    wp_nonce_field('osm_settings_form');
    echo '<table class="form-table">
        <tr><th><label for="osm_appkey">App Key</label></th>
        <td><input type="text" name="osm_appkey" value="' . esc_attr($appkey) . '" class="regular-text"></td></tr>
        <tr><th><label for="osm_authkey">Auth Key</label></th>
        <td><input type="text" name="osm_authkey" value="' . esc_attr($authkey) . '" class="regular-text"></td></tr>
    </table><p class="submit"><input type="submit" name="osm_save_settings" class="button-primary" value="Kaydet"></p></form></div>';
}

function osm_status_messages_page() {
    if (isset($_POST['osm_save_status_messages']) && check_admin_referer('osm_status_messages_form')) {
        $status_messages = array_map('sanitize_textarea_field', $_POST['status_messages']);
        update_option('osm_status_messages', $status_messages);
        echo '<div class="updated"><p>Durum mesajları kaydedildi.</p></div>';
    }
    $statuses = wc_get_order_statuses();
    $status_messages = get_option('osm_status_messages', []);
    echo '<div class="wrap"><h1>Durum Mesajları</h1><form method="post">';
    wp_nonce_field('osm_status_messages_form');
    echo '<table class="form-table">';
    foreach ($statuses as $status => $label) {
        $message = isset($status_messages[$status]) ? $status_messages[$status] : '';
        echo '<tr><th><label for="status_messages[' . esc_attr($status) . ']">' . esc_html($label) . '</label></th>
        <td><textarea name="status_messages[' . esc_attr($status) . ']" class="large-text">' . esc_textarea($message) . '</textarea></td></tr>';
    }
    echo '</table><p class="submit"><input type="submit" name="osm_save_status_messages" class="button-primary" value="Kaydet"></p></form></div>';
}

add_action('woocommerce_order_status_changed', 'osm_order_status_changed', 10, 4);
function osm_order_status_changed($order_id, $old_status, $new_status, $order = null) {
    if (!$order || !is_a($order, 'WC_Order')) {
        $order = wc_get_order($order_id);
    }
    $status_messages = get_option('osm_status_messages', []);
    $status_key = 'wc-' . $new_status;
    if (empty($status_messages[$status_key])) return;
    $customer_name = trim($order->get_billing_first_name() . ' ' . $order->get_billing_last_name());
    $phone = $order->get_billing_phone();
    if (empty($phone)) return;
    $message = str_replace(['{name}', '{order_id}', '{status}'], [$customer_name, $order_id, $new_status], $status_messages[$status_key]);
    osm_send_message($phone, $message);
}

function osm_manual_messaging_page() {
    if (isset($_POST['osm_send_manual_message']) && check_admin_referer('osm_manual_form')) {
        $phone = sanitize_text_field($_POST['phone']);
        $message = sanitize_textarea_field($_POST['message']);
        if (!empty($phone) && !empty($message)) {
            osm_send_message($phone, $message);
            echo '<div class="updated"><p>Mesaj gönderildi.</p></div>';
        } else {
            echo '<div class="error"><p>Telefon numarası ve mesaj boş olamaz.</p></div>';
        }
    }
    $customers = get_users(['role__in' => ['customer'], 'fields' => ['ID', 'display_name']]);
    echo '<div class="wrap"><h1>Manuel Mesaj Gönder</h1><form method="post">';
    wp_nonce_field('osm_manual_form');
    echo '<table class="form-table">
        <tr><th><label for="customer">Müşteri Seç</label></th><td><select id="customer" name="customer" class="regular-text" onchange="document.getElementById(\'phone\').value = this.value;">
        <option value="">-- Müşteri Seç --</option>';
    foreach ($customers as $customer) {
        $phone = get_user_meta($customer->ID, 'billing_phone', true);
        echo '<option value="' . esc_attr($phone) . '">' . esc_html($customer->display_name) . ' (' . esc_html($phone) . ')</option>';
    }
    echo '</select></td></tr>
        <tr><th><label for="phone">Telefon Numarası</label></th><td><input type="text" id="phone" name="phone" class="regular-text"></td></tr>
        <tr><th><label for="message">Mesaj</label></th><td><textarea name="message" class="large-text"></textarea></td></tr>
    </table><p class="submit"><input type="submit" name="osm_send_manual_message" class="button-primary" value="Gönder"></p></form></div>';
}

function osm_format_phone($phone) {
    $phone = preg_replace('/[^0-9]/', '', $phone);
    if (strlen($phone) === 10) {
        $phone = '90' . $phone;
    } elseif (strlen($phone) === 11 && $phone[0] === '0') {
        $phone = '90' . substr($phone, 1);
    } elseif (strlen($phone) === 13 && substr($phone, 0, 3) === '905') {
        $phone = substr($phone, 1);
    }
    return (strlen($phone) === 12 && substr($phone, 0, 2) === '90') ? $phone : false;
}

function osm_send_message($phone, $message) {
    $appkey = get_option('osm_appkey');
    $authkey = get_option('osm_authkey');
    $phone = osm_format_phone($phone);
    if (!$appkey || !$authkey || !$phone || !$message) {
        error_log('Eksik veya geçersiz veri: Mesaj gönderilemedi.');
        return;
    }
    $response = wp_remote_post('https://app.wpro.ltd/api/create-message', [
        'body' => [
            'appkey' => $appkey,
            'authkey' => $authkey,
            'to' => $phone,
            'message' => $message
        ]
    ]);
    if (is_wp_error($response)) {
        error_log('Mesaj hatası: ' . $response->get_error_message());
    } else {
        error_log('Mesaj gönderildi: ' . wp_remote_retrieve_body($response));
    }
}
