<?php
/**
 * Plugin Name: App.WPRO
 * Description: Sipariş durumu değiştikçe mesaj gönderir ve manuel mesaj gönderimi sağlar.
 * Version: 1.1
 * Author: Selahattin ÇEKİÇ
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Admin Menu Eklenmesi
add_action('admin_menu', 'osm_add_admin_menu');
function osm_add_admin_menu() {
    add_menu_page('App.WPRO', 'App.WPRO', 'manage_options', 'osm-settings', 'osm_settings_page');
    add_submenu_page('osm-settings', 'Status Messages', 'Status Messages', 'manage_options', 'osm-status-messages', 'osm_status_messages_page');
    add_submenu_page('osm-settings', 'Manual Messaging', 'Manual Messaging', 'manage_options', 'osm-manual-messaging', 'osm_manual_messaging_page');
}

// Ayarlar Sayfası İçeriği
function osm_settings_page() {
    if ($_POST['osm_save_settings']) {
        update_option('osm_appkey', sanitize_text_field($_POST['osm_appkey']));
        update_option('osm_authkey', sanitize_text_field($_POST['osm_authkey']));
        echo '<div class="updated"><p>Ayarlar kaydedildi.</p></div>';
    }

    $appkey = get_option('osm_appkey', '');
    $authkey = get_option('osm_authkey', '');

    echo '<div class="wrap">
        <h1>App.WPRO Settings</h1>
        <form method="post">
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="osm_appkey">App Key</label></th>
                    <td><input type="text" id="osm_appkey" name="osm_appkey" value="' . esc_attr($appkey) . '" class="regular-text"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="osm_authkey">Auth Key</label></th>
                    <td><input type="text" id="osm_authkey" name="osm_authkey" value="' . esc_attr($authkey) . '" class="regular-text"></td>
                </tr>
            </table>
            <p class="submit"><input type="submit" name="osm_save_settings" class="button-primary" value="Kaydet"></p>
        </form>
    </div>';
}

// Sipariş Durumlarına Göre Mesaj Ayarları
function osm_status_messages_page() {
    if ($_POST['osm_save_status_messages']) {
        $status_messages = array_map('sanitize_textarea_field', $_POST['status_messages']);
        update_option('osm_status_messages', $status_messages);
        echo '<div class="updated"><p>Durum mesajları kaydedildi.</p></div>';
    }

    $statuses = wc_get_order_statuses();
    $status_messages = get_option('osm_status_messages', []);

    echo '<div class="wrap">
        <h1>Status Messages</h1>
        <form method="post">
            <table class="form-table">';

    foreach ($statuses as $status => $label) {
        $message = isset($status_messages[$status]) ? $status_messages[$status] : '';
        echo '<tr>
                <th scope="row"><label for="status_messages[' . $status . ']">' . esc_html($label) . '</label></th>
                <td><textarea id="status_messages[' . $status . ']" name="status_messages[' . $status . ']" class="large-text">' . esc_textarea($message) . '</textarea></td>
            </tr>';
    }

    echo '</table>
            <p class="submit"><input type="submit" name="osm_save_status_messages" class="button-primary" value="Kaydet"></p>
        </form>
    </div>';
}

// Sipariş Durumu Değişikliği İzleme
add_action('woocommerce_order_status_changed', 'osm_order_status_changed', 10, 4);
function osm_order_status_changed($order_id, $old_status, $new_status, $order) {
    $status_messages = get_option('osm_status_messages', []);

    if (!isset($status_messages[$new_status])) {
        return;
    }

    $customer_name = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();
    $phone = $order->get_billing_phone();
    $message = str_replace(['{name}', '{order_id}', '{status}'], [$customer_name, $order_id, $new_status], $status_messages[$new_status]);

    osm_send_message($phone, $message);
}

// Manuel Mesaj Gönderme Sayfası
function osm_manual_messaging_page() {
    if ($_POST['osm_send_manual_message']) {
        $phone = sanitize_text_field($_POST['phone']);
        $message = sanitize_textarea_field($_POST['message']);
        osm_send_message($phone, $message);
        echo '<div class="updated"><p>Mesaj gönderildi.</p></div>';
    }

    $customers = get_users(['role__in' => ['customer'], 'fields' => ['ID', 'display_name']]);

    echo '<div class="wrap">
        <h1>Manual Messaging</h1>
        <form method="post">
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="customer">Müşteri Seç</label></th>
                    <td>
                        <select id="customer" name="customer" class="regular-text" onchange="document.getElementById('phone').value = this.value;">
                            <option value="">-- Müşteri Seç --</option>';

    foreach ($customers as $customer) {
        $user_meta = get_user_meta($customer->ID);
        $phone = isset($user_meta['billing_phone'][0]) ? $user_meta['billing_phone'][0] : '';
        echo '<option value="' . esc_attr($phone) . '">' . esc_html($customer->display_name) . ' (' . esc_html($phone) . ')</option>';
    }

    echo '        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="phone">Telefon Numarası</label></th>
                    <td><input type="text" id="phone" name="phone" class="regular-text"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="message">Mesaj</label></th>
                    <td><textarea id="message" name="message" class="large-text"></textarea></td>
                </tr>
            </table>
            <p class="submit"><input type="submit" name="osm_send_manual_message" class="button-primary" value="Gönder"></p>
        </form>
    </div>';
}

// Mesaj Gönderme Fonksiyonu
function osm_send_message($phone, $message) {
    $appkey = get_option('osm_appkey');
    $authkey = get_option('osm_authkey');

    $response = wp_remote_post('https://app.wpro.ltd/api/create-message', [
        'body' => [
            'appkey' => $appkey,
            'authkey' => $authkey,
            'to' => $phone,
            'message' => $message
        ]
    ]);

    if (is_wp_error($response)) {
        error_log('Mesaj gönderimi başarısız: ' . $response->get_error_message());
    } else {
        error_log('Mesaj gönderildi: ' . wp_remote_retrieve_body($response));
    }
}
